#ifndef __ARRAY_H
#define __ARRAY_H

template<class BaseType, int size = 100>
class Array {
    BaseType member[size];
public:
    class OutOfRangeException: public exception {};
    BaseType & operator [] (int i) { return member[i]; }
    BaseType & at(int i) {
        if (i < 0 || i > size) throw OutOfRangeException();
        return member[i];
    }
};

#endif
